// This file contains everything specific to team toggling / charming / capturing
var CB;
(function (CB) {
    var TeamChanging;
    (function (TeamChanging) {
        var cb = global.craig_brett;
        var TeamChange = (function () {
            function TeamChange(sourceUnit, targetUnit) {
                this.Source = sourceUnit;
                this.Target = targetUnit;
                this.FormerTeam = targetUnit.Team;
            }
            return TeamChange;
        })();
        function toggle_team(e) {
            /// <summary>Changes the team of the target to its opposing team</summary>
            /// <param name="e">The event object, containing information about the event. </param>
            var target = e.target;
            var source = e.source;
            var skill = e.skill;
            var effect = e.effect;
            var effecter;
            if (skill)
                effecter = skill;
            else if (effect)
                effecter = effect;
            else
                say("Error: No skill or effect for toggle_team");
            var flags = effecter.ScriptFlags;
            var chance = 100, successNecessary = false, toggleStageSuccess;
            var chanceFlag = flags.get("toggle_team_chance");
            if (chanceFlag) {
                chance = chanceFlag * 100;
            }
            if (chance === 100) {
                toggleStageSuccess = true;
            }
            else {
                var random = Math.round((Math.random() * 100) + 1);
                toggleStageSuccess = chance >= random;
            }
            if (flags.get("toggle_team_needs_success"))
                successNecessary = flags.get("toggle_team_needs_success");
            if (target.Team == source.Team && !flags.get("toggle_to_team")) {
                return; // no need to go any further
            }
            var toggleResult = toggleStageSuccess && ((successNecessary && e.success) || !successNecessary);
            // another debug line
            // say("Decision calculation: Toggle stage success = " + toggleStageSuccess + ". Success necessary = " + successNecessary + ". e.Success = " + e.success + ". Overall result = " + toggleResult);
            var immune = target.ScriptFlags.get("toggle_team_immune");
            if (immune) {
                toggleResult = false;
            }
            if (toggleResult == true) {
                if (flags.get("toggle_team_success_message")) {
                    var msg = CB.chooseFromARandomSelectString(flags.get("toggle_team_success_message"));
                    say(msg.format(source.GetName(), target.GetName()));
                }
                // add this action into the TeamChanges array
                cb.TeamChanges[target.ID] = new TeamChange(source, target);
                if (flags.get("toggle_to_team"))
                    target.Team = flags.get("toggle_to_team");
                else
                    target.Team = source.Team;
                // there's been a unit update. SHare it if this is multiplayer
                shared.ShareUnitUpdate(target);
            }
            else {
                if (flags.get("toggle_team_failure_message")) {
                    var msg = CB.chooseFromARandomSelectString(flags.get("toggle_team_failure_message"));
                    say(msg.format(source.GetName(), target.GetName()));
                }
            }
        }
        TeamChanging.toggle_team = toggle_team;
        function untoggle_team(target) {
            /// <summary>Turns a unit back to its original team</summary>
            /// <param name="e">The target to be untoggle_teamed. </param>
            if (cb.TeamChanges[target.ID] != null) {
                target.Team = cb.TeamChanges[target.ID].FormerTeam;
                cb.TeamChanges.Remove(target.ID);
                shared.ShareUnitUpdate(target);
                return;
            }
            else {
                say("Unable to find original team of unit.");
                return;
            }
        }
        TeamChanging.untoggle_team = untoggle_team;
    })(TeamChanging = CB.TeamChanging || (CB.TeamChanging = {}));
})(CB || (CB = {}));
